/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf;

import cz.xtf.io.IOUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jboss.dmr.ModelNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UsageRecorder {
    private static final Logger LOGGER = LoggerFactory.getLogger(UsageRecorder.class);
    private static final UsageRecorder INSTANCE = new UsageRecorder();
    private final ModelNode json;
    private final Path jsonFile;
    private final Set<TemplateRecord> templateRecords = new HashSet<TemplateRecord>();
    private final Set<ImageRecord> imageRecords = new HashSet<ImageRecord>();

    public static void recordImage(String imagestream, String image) {
        if (UsageRecorder.INSTANCE.imageRecords.add(new ImageRecord(imagestream, image))) {
            ModelNode imageNode = UsageRecorder.INSTANCE.json.get("images").add();
            imageNode.get("image-stream").set(imagestream);
            imageNode.get("image").set(image);
            UsageRecorder.flush();
        }
    }

    public static void recordTemplate(String name, String repository, String branch, String commitId) {
        if (UsageRecorder.INSTANCE.templateRecords.add(new TemplateRecord(name, repository, branch, commitId))) {
            ModelNode templateNode = UsageRecorder.INSTANCE.json.get("templates").add();
            templateNode.get("name").set(name);
            templateNode.get("repository").set(repository);
            templateNode.get("branch").set(branch);
            templateNode.get("commit").set(commitId);
            UsageRecorder.flush();
        }
    }

    public static void recordOpenShiftVersion(String openShiftVersion) {
        UsageRecorder.INSTANCE.json.get(new String[]{"versions", "openshift"}).set(openShiftVersion);
        UsageRecorder.flush();
    }

    public static void recordKubernetesVersion(String kubeVersion) {
        UsageRecorder.INSTANCE.json.get(new String[]{"versions", "kubernetes"}).set(kubeVersion);
        UsageRecorder.flush();
    }

    public static void storeProperty(String name, String value) {
        ModelNode propertyNode = UsageRecorder.INSTANCE.json.get("properties").add();
        propertyNode.get("name").set(name);
        propertyNode.get("value").set(value);
    }

    public static void flush() {
        INSTANCE.saveJson();
    }

    private UsageRecorder() {
        this.json = new ModelNode();
        this.json.get("versions").setEmptyObject();
        this.json.get("images").setEmptyList();
        this.json.get("templates").setEmptyList();
        this.json.get("properties").setEmptyList();
        this.jsonFile = IOUtils.findProjectRoot().resolve("usage.json");
        this.saveJson();
    }

    private void saveJson() {
        try (BufferedWriter writer = Files.newBufferedWriter(this.jsonFile, new OpenOption[0]);){
            writer.write(this.json.toJSONString(false));
            writer.newLine();
            writer.flush();
        }
        catch (IOException ex) {
            LOGGER.error("Failed to save usage records", (Throwable)ex);
        }
    }

    private static class ImageRecord {
        private final String streamName;
        private final String image;

        ImageRecord(String streamName, String image) {
            if (StringUtils.isBlank((CharSequence)streamName) || StringUtils.isBlank((CharSequence)image)) {
                throw new IllegalArgumentException("Image stream name and image url must not be blank");
            }
            this.streamName = streamName;
            this.image = image;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImageRecord that = (ImageRecord)o;
            return this.streamName.equals(that.streamName) && this.image.equals(that.image);
        }

        public int hashCode() {
            int result = this.streamName.hashCode();
            result = 31 * result + this.image.hashCode();
            return result;
        }
    }

    private static class TemplateRecord {
        private final String name;
        private final String repository;
        private final String branch;
        private final String commit;

        TemplateRecord(String name, String repository, String branch, String commit) {
            if (StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)repository)) {
                throw new IllegalArgumentException("Template name and repository must not be blank");
            }
            this.name = name;
            this.repository = repository;
            this.branch = branch;
            this.commit = commit;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemplateRecord that = (TemplateRecord)o;
            return this.name.equals(that.name) && this.repository.equals(that.repository) && (this.branch != null ? this.branch.equals(that.branch) : that.branch == null) && (this.commit != null ? this.commit.equals(that.commit) : that.commit == null);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.repository.hashCode();
            result = 31 * result + (this.branch != null ? this.branch.hashCode() : 0);
            result = 31 * result + (this.commit != null ? this.commit.hashCode() : 0);
            return result;
        }
    }
}

