/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.docker;

import cz.xtf.docker.OpenShiftNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerInspect {
    private static final Logger log = LoggerFactory.getLogger(DockerInspect.class);
    private final ModelNode dockerInspect;

    public static DockerInspect from(String image) {
        log.info("Pulling image '{}' to master", (Object)image);
        OpenShiftNode.master().executeCommand("sudo docker pull " + image);
        String result = OpenShiftNode.master().executeCommand("sudo docker inspect " + image);
        log.debug("Docker inspect result:\n'{}'", (Object)result);
        return new DockerInspect(ModelNode.fromJSONString((String)result).get(0));
    }

    private DockerInspect(ModelNode dockerInspect) {
        this.dockerInspect = dockerInspect;
    }

    public Map<String, String> labels() {
        return this.dockerInspect.get(new String[]{"Config", "Labels"}).asPropertyList().stream().collect(Collectors.toMap(Property::getName, property -> property.getValue().asString()));
    }

    public String command() {
        return this.dockerInspect.get(new String[]{"Config", "Cmd"}).get(0).asString();
    }

    public Map<String, String> envs() {
        HashMap env = new HashMap();
        this.dockerInspect.get(new String[]{"Config", "Env"}).asList().forEach(node -> {
            String[] keyValue = node.asString().split("=", 2);
            env.put(keyValue[0], keyValue[1]);
        });
        return Collections.unmodifiableMap(env);
    }

    public Set<Integer> exposedPorts(String protocol) {
        HashSet<Integer> result = new HashSet<Integer>();
        ModelNode exposedPorts = this.dockerInspect.get(new String[]{"Config", "ExposedPorts"});
        if (exposedPorts.getType() != ModelType.UNDEFINED) {
            exposedPorts.keys().forEach(portDef -> {
                String[] split = portDef.split("/");
                if (StringUtils.isBlank((CharSequence)protocol) || split[1].equalsIgnoreCase(protocol)) {
                    result.add(Integer.parseInt(split[0]));
                }
            });
        }
        return result;
    }
}

