/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.git;

import cz.xtf.io.IOUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitProject {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitProject.class);
    public static final String ENV_FILE_LOCATION = ".s2i/environment";
    private final Git repo;
    private final Path path;
    private CredentialsProvider credentials;
    private String httpUrl;

    public GitProject(Path location) throws IOException {
        this(location, Git.open((File)location.toFile()), null);
    }

    GitProject(Path path, Git repo, CredentialsProvider credentials) {
        this.path = path;
        this.repo = repo;
        this.credentials = credentials;
    }

    public String getName() {
        return this.path.getFileName().toString();
    }

    public String getUrl() {
        return this.getUrl("origin");
    }

    public void setUrl(String url) {
        this.setUrl(url, "origin");
    }

    public Path getPath() {
        return this.path;
    }

    public void setCredentials(CredentialsProvider credentials) {
        this.credentials = credentials;
    }

    public String getUrl(String remote) {
        return this.repo.getRepository().getConfig().getString("remote", remote, "url");
    }

    public String getRevHash() {
        try {
            return this.repo.getRepository().getRef("HEAD").getObjectId().getName();
        }
        catch (IOException ex) {
            LOGGER.error("Error retrieving HEAD revision", (Throwable)ex);
            return null;
        }
    }

    void setUrl(String url, String remote) {
        if (url != null && url.length() > 0) {
            StoredConfig config = this.repo.getRepository().getConfig();
            config.setString("remote", remote, "url", url);
            try {
                config.save();
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to save repository configuration", ex);
            }
        }
    }

    void setHttpUrl(String httpUrl) {
        this.httpUrl = httpUrl;
    }

    public String getHttpUrl() {
        return this.httpUrl;
    }

    public void pull() {
        try {
            if (this.credentials != null) {
                ((PullCommand)this.repo.pull().setCredentialsProvider(this.credentials)).setRebase(true).call();
            } else {
                this.repo.pull().setRebase(true).call();
            }
        }
        catch (GitAPIException ex) {
            LOGGER.error("Error during pull.", (Throwable)ex);
        }
    }

    public void add(Path file) {
        try {
            this.repo.add().addFilepattern(this.path.relativize(file).toString()).call();
        }
        catch (GitAPIException ex) {
            LOGGER.error("Unable to add files", (Throwable)ex);
        }
    }

    public void addAll() {
        try {
            this.repo.add().addFilepattern(".").call();
        }
        catch (GitAPIException ex) {
            LOGGER.error("Unable to add all files", (Throwable)ex);
        }
    }

    public void commit(String message) {
        try {
            this.repo.commit().setAll(true).setMessage(message).call();
        }
        catch (GitAPIException ex) {
            LOGGER.error("Unable to commit changes.", (Throwable)ex);
        }
    }

    public void push() {
        try {
            if (this.credentials != null) {
                ((PushCommand)this.repo.push().setCredentialsProvider(this.credentials)).call();
            } else {
                this.repo.push().call();
            }
        }
        catch (GitAPIException ex) {
            LOGGER.error("Error during push.", (Throwable)ex);
        }
    }

    public void checkout(String ref) {
        try {
            this.repo.checkout().setName(ref).call();
        }
        catch (GitAPIException ex) {
            LOGGER.error("Failed to checkout ref '" + ref + "'", (Throwable)ex);
        }
    }

    public void delete() {
        this.repo.close();
        try {
            IOUtils.deleteDirectory(this.path);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to delete project '" + this.getName() + "'", ex);
        }
    }

    public void configureSTIBuildFile(Map<String, String> env) {
        try {
            Path envFile = this.path.resolve(ENV_FILE_LOCATION);
            FileUtils.writeLines((File)envFile.toFile(), (Collection)env.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.toList()), (boolean)true);
            this.repo.add().addFilepattern(ENV_FILE_LOCATION).call();
        }
        catch (IOException | GitAPIException ex) {
            LOGGER.error("Error when configuring STI", ex);
            throw new IllegalStateException("Error when configuring STI", ex);
        }
    }

    public void addProfileToSTIBuild(String profileName) {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("MAVEN_ARGS", "package -Popenshift," + profileName + " -DskipTests -Dcom.redhat.xpaas.repo.redhatga");
        this.configureSTIBuildFile(env);
    }

    public void removeSTIBuildFile() {
        Path envFile = this.path.resolve(ENV_FILE_LOCATION);
        if (Files.exists(envFile, new LinkOption[0])) {
            try {
                this.repo.rm().addFilepattern(ENV_FILE_LOCATION).call();
            }
            catch (GitAPIException ex) {
                LOGGER.error("Error when configuring STI", (Throwable)ex);
                throw new IllegalStateException("Error when deleting STI configuration file", ex);
            }
        }
    }

    public void submodulesInitialization() {
        try {
            this.repo.submoduleInit().call();
            this.repo.submoduleUpdate().call();
        }
        catch (GitAPIException e) {
            throw new IllegalArgumentException("Unable to update submodules");
        }
    }

    public void close() {
        this.repo.close();
    }
}

