/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.http;

import cz.xtf.TestConfiguration;
import cz.xtf.http.TrustEverythingStrategy;
import cz.xtf.keystore.KeystoreType;
import cz.xtf.tuple.Tuple;
import cz.xtf.wait.WaitingException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClient.class);
    private static final long HTTP_WAIT_TIMEOUT = 1L;
    private static final long HTTP_POLL_INTERVAL = 1L;
    private final URL url;
    private HttpUriRequest request;
    private SSLConnectionSocketFactory sslsf = null;
    private boolean preemptiveAuth;
    private String username;
    private String password;
    private CloseableHttpClient httpClient;
    private boolean disableRedirect = false;
    private final Map<String, String> cookies = new HashMap<String, String>();
    private KeystoreType keystoreType = KeystoreType.JKS;

    public static HttpClient get(String urlString) throws MalformedURLException {
        return new HttpClient(urlString, (HttpUriRequest)new HttpGet(urlString));
    }

    public static HttpClient post(String urlString) throws MalformedURLException {
        return new HttpClient(urlString, (HttpUriRequest)new HttpPost(urlString));
    }

    public static HttpClient put(String urlString) throws MalformedURLException {
        return new HttpClient(urlString, (HttpUriRequest)new HttpPut(urlString));
    }

    public static HttpClient delete(String urlString) throws MalformedURLException {
        return new HttpClient(urlString, (HttpUriRequest)new HttpDelete(urlString));
    }

    public static HttpClient reuseable(String urlString, String username, String password) throws IOException {
        HttpClient hc = new HttpClient(urlString, null).basicAuth(username, password);
        hc.httpClient = hc.build();
        return hc;
    }

    public static HttpClient reuseable(String urlString) throws IOException {
        HttpClient hc = new HttpClient(urlString, null);
        hc.httpClient = hc.build();
        return hc;
    }

    public static HttpClient reuseableNoRetry(String urlString) throws IOException {
        HttpClient hc = new HttpClient(urlString, null);
        hc.httpClient = hc.build(HttpClientBuilder::disableAutomaticRetries);
        return hc;
    }

    private HttpClient(String url, HttpUriRequest request) throws MalformedURLException {
        this.url = new URL(url);
        this.request = request;
    }

    public HttpClient basicAuth(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    public HttpClient bearerAuth(String token) {
        this.request.setHeader("Authorization", String.format("Bearer %s", token));
        return this;
    }

    public HttpClient preemptiveAuth() {
        this.preemptiveAuth = true;
        return this;
    }

    public HttpClient disableRedirect() {
        this.disableRedirect = true;
        return this;
    }

    public HttpClient trustStore(Path trustStorePath, String trustStorePassword) {
        return this.trustStore(trustStorePath, trustStorePassword.toCharArray(), false);
    }

    public HttpClient trustStore(Path trustStorePath, char[] trustStorePassword) {
        return this.trustStore(trustStorePath, trustStorePassword, false);
    }

    public HttpClient trustStore(Path trustStorePath, String trustStorePassword, boolean strictHostnameChecking) {
        return this.trustStore(trustStorePath, trustStorePassword.toCharArray(), strictHostnameChecking);
    }

    public HttpClient trustStore(Path trustStorePath, char[] trustStorePassword, boolean strictHostnameChecking) {
        this.sslsf = HttpClient.createSSLConnectionSocketFactory(trustStorePath, trustStorePassword, strictHostnameChecking, this.keystoreType);
        return this;
    }

    public HttpClient trustStoreType(KeystoreType type) {
        this.keystoreType = type;
        return this;
    }

    public HttpClient header(String name, String value) {
        this.request.setHeader(name, value);
        return this;
    }

    public HttpClient addHeader(String name, String value) {
        this.request.addHeader(name, value);
        return this;
    }

    public HttpClient cookie(String name, String value) {
        this.cookies.put(name, value);
        return this;
    }

    public HttpClient data(String data, ContentType contentType) {
        StringEntity entity;
        if (!(this.request instanceof HttpEntityEnclosingRequest)) {
            throw new IllegalStateException("Can't add data to " + this.request.getClass().getSimpleName());
        }
        if (data != null) {
            entity = new StringEntity(data, contentType);
        } else {
            BasicHttpEntity cEntity = new BasicHttpEntity();
            cEntity.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
            if (contentType != null) {
                cEntity.setContentType(contentType.toString());
            }
            entity = cEntity;
        }
        ((HttpEntityEnclosingRequest)this.request).setEntity((HttpEntity)entity);
        return this;
    }

    /*
     * Exception decompiling
     */
    public int code() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Tuple.Pair<String, Integer> responseAndCode(CloseableHttpClient hc) throws IOException {
        return this.response(hc, response -> Tuple.pair(EntityUtils.toString((HttpEntity)response.getEntity()), response.getStatusLine().getStatusCode()));
    }

    public Tuple.Pair<String, Integer> responseAndCode() throws IOException {
        try (CloseableHttpClient hc = this.build();){
            Tuple.Pair<String, Integer> pair = this.responseAndCode(hc);
            return pair;
        }
    }

    public Tuple.Pair<String, Integer> responseAndCodeNoClose() throws IOException {
        return this.responseAndCode(this.httpClient);
    }

    public String response() throws IOException {
        try (CloseableHttpClient hc = this.build();){
            String string = this.response(hc);
            return string;
        }
    }

    public List<Header> responseHeaders() throws IOException {
        try (CloseableHttpResponse response = this.build().execute(this.request);){
            List<Header> list = Arrays.asList(response.getAllHeaders());
            return list;
        }
    }

    public byte[] responseBytes() throws IOException {
        return this.response(this.build(), response -> EntityUtils.toByteArray((HttpEntity)response.getEntity()));
    }

    public String responseNoClose() throws IOException {
        return this.response(this.httpClient);
    }

    private <T> T response(CloseableHttpClient hc, HttpResponseTransform<T> transform) throws IOException {
        try (CloseableHttpResponse response = hc.execute(this.request);){
            T ret = transform.transform((HttpResponse)response);
            EntityUtils.consume((HttpEntity)response.getEntity());
            LOGGER.debug("Response: {}", ret);
            T t = ret;
            return t;
        }
    }

    private String response(CloseableHttpClient hc) throws IOException {
        return this.response(hc, response -> EntityUtils.toString((HttpEntity)response.getEntity()));
    }

    public Tuple.Pair<String, List<Header>> responseAndResponseHeaders() throws IOException {
        return this.response(this.build(), response -> Tuple.pair(EntityUtils.toString((HttpEntity)response.getEntity()), Arrays.asList(response.getAllHeaders())));
    }

    public Tuple.Triple<String, Integer, List<Header>> responseAndCodeAndResponseHeaders() throws IOException {
        return this.response(this.build(), response -> Tuple.triple(EntityUtils.toString((HttpEntity)response.getEntity()), response.getStatusLine().getStatusCode(), Arrays.asList(response.getAllHeaders())));
    }

    public void waitForOk() {
        this.waitForCode(200, 1L, TimeUnit.MINUTES);
    }

    public void waitForOk(long timeout, TimeUnit unit) {
        this.waitForCode(200, timeout, unit);
    }

    public void waitForCode(int code) {
        this.waitForCode(code, 1L, TimeUnit.MINUTES);
    }

    public void waitForCode(int code, long timeout, TimeUnit unit) {
        long startTime = System.currentTimeMillis();
        int lastCode = -1;
        do {
            try {
                TimeUnit.SECONDS.sleep(1L);
                lastCode = this.code();
            }
            catch (IOException | InterruptedException ex) {
                LOGGER.debug("Error retrieving HTTP code", (Throwable)ex);
            }
        } while (lastCode != code && System.currentTimeMillis() - startTime < TimeUnit.MILLISECONDS.convert(timeout, unit));
        if (lastCode != code) {
            throw new WaitingException(String.format("Cannot %s %s %s after %s %s. Last HTTP status: %s", this.request.getMethod(), this.url, code, timeout, unit.name(), lastCode));
        }
    }

    private CloseableHttpClient build() throws IOException {
        return this.build(null);
    }

    private CloseableHttpClient build(Consumer<HttpClientBuilder> customizeBuilder) throws IOException {
        LOGGER.debug("HTTP {} {}", (Object)this.request, (Object)this.url);
        if (this.httpClient != null) {
            LOGGER.debug("Existing HttpClient re-used");
            return this.httpClient;
        }
        if (this.sslsf == null) {
            this.sslsf = HttpClient.createSSLConnectionSocketFactory(null, null, false);
        }
        HttpClientBuilder builder = HttpClients.custom().setRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler(3, true){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                try {
                    TimeUnit.SECONDS.sleep(3L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return super.retryRequest(exception, executionCount, context);
            }
        }).setSSLSocketFactory((LayeredConnectionSocketFactory)this.sslsf);
        if (this.username != null) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(this.url.getHost(), this.url.getPort() == -1 ? this.url.getDefaultPort() : this.url.getPort()), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
            builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        }
        if (this.disableRedirect) {
            builder.disableRedirectHandling();
        }
        this.addPreemptiveAuthorizationHeaders();
        if (customizeBuilder != null) {
            customizeBuilder.accept(builder);
        }
        if (!this.cookies.isEmpty()) {
            BasicCookieStore cookieStore = new BasicCookieStore();
            this.cookies.entrySet().stream().map(x -> new BasicClientCookie((String)x.getKey(), (String)x.getValue())).forEach(arg_0 -> ((CookieStore)cookieStore).addCookie(arg_0));
            builder.setDefaultCookieStore((CookieStore)cookieStore);
        }
        return builder.build();
    }

    public HttpClient addPreemptiveAuthorizationHeaders() {
        if (this.preemptiveAuth && this.username != null && this.password != null && this.request != null) {
            String credentials = StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])(this.username + ":" + this.password).getBytes(StandardCharsets.UTF_8), (boolean)false));
            this.request.setHeader("Authorization", String.format("Basic %s", credentials));
        }
        return this;
    }

    private static SSLConnectionSocketFactory createSSLConnectionSocketFactory(Path path, char[] password, boolean strict) {
        return HttpClient.createSSLConnectionSocketFactory(path, password, strict, KeystoreType.JKS);
    }

    private static SSLConnectionSocketFactory createSSLConnectionSocketFactory(Path path, char[] password, boolean strict, KeystoreType keystoreType) {
        try {
            SSLContextBuilder builder = SSLContexts.custom();
            if (path != null) {
                KeyStore trustStore = KeyStore.getInstance(keystoreType.name());
                try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                    trustStore.load(is, password);
                }
                builder.loadTrustMaterial(trustStore);
            } else {
                builder.loadTrustMaterial(null, (TrustStrategy)new TrustEverythingStrategy());
            }
            X509HostnameVerifier verifier = strict ? SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER : SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
            return new SSLConnectionSocketFactory(builder.build(), new String[]{"TLSv1", "TLSv1.2"}, null, verifier);
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new RuntimeException("Can't create SSL connection factory", ex);
        }
    }

    public HttpClient request(HttpUriRequest request) {
        this.request = request;
        this.addPreemptiveAuthorizationHeaders();
        return this;
    }

    public Tuple.Pair<String, Integer> guaranteedRequest(IOFunction<HttpClient, Tuple.Pair<String, Integer>> request) {
        for (int i = 0; i < TestConfiguration.maxHttpTries(); ++i) {
            try {
                Tuple.Pair<String, Integer> reply = request.apply(this);
                if (reply.getSecond() < 500 || reply.getSecond() >= 600) {
                    return reply;
                }
                LOGGER.info("Request returned {}", (Object)reply.getSecond());
            }
            catch (IOException e1) {
                LOGGER.info("IO Exception", (Throwable)e1);
            }
            try {
                TimeUnit.SECONDS.sleep(1L);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.error("Interruted", (Throwable)e);
                throw new IllegalStateException("Interrupted", e);
            }
        }
        throw new RuntimeException("Http call failed");
    }

    @FunctionalInterface
    private static interface HttpResponseTransform<T> {
        public T transform(HttpResponse var1) throws IOException;
    }

    @FunctionalInterface
    public static interface IOFunction<T, R> {
        public R apply(T var1) throws IOException;
    }
}

