/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit;

import com.google.common.base.Predicate;
import cz.xtf.junit.XTFTestSuite;
import cz.xtf.junit.annotation.TestFilterMethod;
import cz.xtf.junit.annotation.TestSuffix;
import cz.xtf.junit.filter.AbstractClassFilter;
import cz.xtf.junit.filter.AllClassesInclusionFilter;
import cz.xtf.junit.filter.AnnotationNameFilter;
import cz.xtf.junit.filter.ClassNameRegExExclusionFilter;
import cz.xtf.junit.filter.ClassNameSuffixInclusionFilter;
import cz.xtf.junit.filter.CompositeExclusionTestClassFilter;
import cz.xtf.junit.filter.CompositeExclusionTestNameFilter;
import cz.xtf.junit.filter.CompositeInclusionTestClassFilter;
import cz.xtf.junit.filter.CompositeInclusionTestNameFilter;
import cz.xtf.junit.filter.ExclusionTestClassFilter;
import cz.xtf.junit.filter.ExclusionTestNameFilter;
import cz.xtf.junit.filter.InclusionTestClassFilter;
import cz.xtf.junit.filter.InclusionTestNameFilter;
import cz.xtf.junit.filter.JenkinsRerunFilter;
import cz.xtf.junit.filter.ManualTestFilter;
import cz.xtf.junit.filter.NoAnnotationNameFilter;
import cz.xtf.junit.filter.SinceVersionFilter;
import cz.xtf.junit.filter.SuiteClassFilter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XTFTestSuiteHelper {
    private static final Logger log = LoggerFactory.getLogger(XTFTestSuiteHelper.class);
    private static final String PATH_SEPARATOR = System.getProperty("file.separator");
    private final Class<?> suiteClass;
    private final Path rootPackage;
    private final CompositeInclusionTestNameFilter inclusionTestNameFilter;
    private final CompositeInclusionTestClassFilter inclusionTestClassFilter;
    private final CompositeExclusionTestNameFilter exclusionTestNameFilter;
    private final CompositeExclusionTestClassFilter exclusionTestClassFilter;

    XTFTestSuiteHelper(@NonNull Class<?> suiteClass) throws URISyntaxException {
        if (suiteClass == null) {
            throw new NullPointerException("suiteClass");
        }
        this.suiteClass = suiteClass;
        this.rootPackage = XTFTestSuiteHelper.getRootPackagePath(suiteClass);
        this.inclusionTestNameFilter = XTFTestSuiteHelper.constructInclusionTestNameFilter(suiteClass);
        this.inclusionTestClassFilter = XTFTestSuiteHelper.constructInclusionTestClassFilter(suiteClass);
        this.exclusionTestNameFilter = XTFTestSuiteHelper.constructExclusionTestNameFilter(suiteClass);
        this.exclusionTestClassFilter = XTFTestSuiteHelper.constructExclusionTestClassFilter(suiteClass);
    }

    private static boolean isNotAnonymousNorInnerClass(Path path) {
        return !path.toString().contains("$");
    }

    private static boolean isClassFile(Path path) {
        return path.toString().endsWith(".class");
    }

    private static String convertToClassName(Path rootPackagePath, Path path) {
        return rootPackagePath.relativize(path).toString().replace(PATH_SEPARATOR.charAt(0), '.').replace(".class", "");
    }

    private static Stream<Class<?>> convertToClass(String className) {
        try {
            return Stream.of(Class.forName(className));
        }
        catch (ClassNotFoundException | NoClassDefFoundError ex) {
            log.error("Could not find test class class={}", (Object)className, (Object)ex);
            return Stream.of(new Class[0]);
        }
    }

    private static CompositeInclusionTestNameFilter constructInclusionTestNameFilter(Class<?> suiteClass) {
        CompositeInclusionTestNameFilter filters = new CompositeInclusionTestNameFilter();
        filters.addFilter(new ClassNameSuffixInclusionFilter(XTFTestSuiteHelper.resolveTestSuffix(suiteClass)));
        filters.addFilters(XTFTestSuiteHelper.getDeclaredFilters(suiteClass, InclusionTestNameFilter.class));
        return filters;
    }

    private static CompositeInclusionTestClassFilter constructInclusionTestClassFilter(Class<?> suiteClass) {
        CompositeInclusionTestClassFilter filters = new CompositeInclusionTestClassFilter();
        filters.addFilter(AllClassesInclusionFilter.instance());
        filters.addFilters(XTFTestSuiteHelper.getDeclaredFilters(suiteClass, InclusionTestClassFilter.class));
        return filters;
    }

    private static CompositeExclusionTestNameFilter constructExclusionTestNameFilter(Class<?> suiteClass) {
        CompositeExclusionTestNameFilter filters = new CompositeExclusionTestNameFilter();
        filters.addFilter(new ClassNameRegExExclusionFilter());
        filters.addFilter(new SuiteClassFilter(suiteClass));
        filters.addFilters(XTFTestSuiteHelper.getDeclaredFilters(suiteClass, ExclusionTestNameFilter.class));
        return filters;
    }

    private static CompositeExclusionTestClassFilter constructExclusionTestClassFilter(Class<?> suiteClass) {
        CompositeExclusionTestClassFilter filters = new CompositeExclusionTestClassFilter();
        filters.addFilter(AbstractClassFilter.instance());
        filters.addFilter(ManualTestFilter.instance());
        filters.addFilter(new AnnotationNameFilter());
        filters.addFilter(new NoAnnotationNameFilter());
        filters.addFilter(new JenkinsRerunFilter());
        filters.addFilter(SinceVersionFilter.instance());
        filters.addFilters(XTFTestSuiteHelper.getDeclaredFilters(suiteClass, ExclusionTestClassFilter.class));
        return filters;
    }

    private static String resolveTestSuffix(Class<?> suiteClass) {
        TestSuffix suffix = suiteClass.getAnnotation(TestSuffix.class);
        return suffix != null ? suffix.value() : "Test";
    }

    private static <T> List<T> getDeclaredFilters(Class<?> suiteClass, Class<T> returnType) {
        Set methods = ReflectionUtils.getAllMethods(suiteClass, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(TestFilterMethod.class), ReflectionUtils.withModifier((int)8), ReflectionUtils.withParametersCount((int)0), ReflectionUtils.withReturnTypeAssignableTo(returnType)});
        return methods.stream().flatMap(m -> {
            try {
                Object filter = m.invoke(null, new Object[0]);
                if (filter != null) {
                    return Stream.of(filter);
                }
            }
            catch (Exception ex) {
                log.warn("Unable to construct test filter ", (Throwable)ex);
            }
            return Stream.of(new Object[0]);
        }).collect(Collectors.toList());
    }

    private static Path getRootPackagePath(Class<?> suiteClass) throws URISyntaxException {
        String rootPackage = StringUtils.substringBefore((String)suiteClass.getName(), (String)".");
        URL url = XTFTestSuite.class.getResource("/" + suiteClass.getName().replace('.', '/') + ".class");
        Path rootPackagePath = Paths.get(url.toURI());
        while (!rootPackage.equals(rootPackagePath.getFileName().toString())) {
            rootPackagePath = rootPackagePath.getParent();
        }
        return rootPackagePath.getParent();
    }

    public List<Class<?>> resolveTestClasses() throws IOException {
        return Files.walk(this.rootPackage, new FileVisitOption[0]).filter(path -> XTFTestSuiteHelper.isClassFile(path)).filter(path -> XTFTestSuiteHelper.isNotAnonymousNorInnerClass(path)).map(path -> XTFTestSuiteHelper.convertToClassName(this.rootPackage, path)).filter(this.inclusionTestNameFilter::include).filter(className -> !this.exclusionTestNameFilter.exclude((String)className)).flatMap(className -> XTFTestSuiteHelper.convertToClass(className)).filter(this.inclusionTestClassFilter::include).filter(testClass -> !this.exclusionTestClassFilter.exclude((Class<?>)testClass)).distinct().sorted((c1, c2) -> c1.getName().compareTo(c2.getName())).collect(Collectors.toList());
    }

    public Class<?> getSuiteClass() {
        return this.suiteClass;
    }

    public Path getRootPackage() {
        return this.rootPackage;
    }

    public CompositeInclusionTestNameFilter getInclusionTestNameFilter() {
        return this.inclusionTestNameFilter;
    }

    public CompositeInclusionTestClassFilter getInclusionTestClassFilter() {
        return this.inclusionTestClassFilter;
    }

    public CompositeExclusionTestNameFilter getExclusionTestNameFilter() {
        return this.exclusionTestNameFilter;
    }

    public CompositeExclusionTestClassFilter getExclusionTestClassFilter() {
        return this.exclusionTestClassFilter;
    }
}

