/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openshift.db;

import cz.xtf.TestConfiguration;
import cz.xtf.model.TransportProtocol;
import cz.xtf.openshift.builder.ApplicationBuilder;
import cz.xtf.openshift.builder.ServiceBuilder;
import cz.xtf.openshift.builder.pod.ContainerBuilder;
import cz.xtf.openshift.db.AbstractDatabase;
import cz.xtf.openshift.imagestream.ImageRegistry;
import java.util.HashMap;
import java.util.Map;

public class Datagrid
extends AbstractDatabase {
    private final String appName;
    private final String username;
    private final String password;
    private final String connectors;
    private final String cacheNames;
    private final String datavirtCacheNames;
    private final String hotrodSvcName;
    private final String jgroupsPasswd;
    private final boolean createService;
    private final int HOTROD_PORT = 11333;
    private final int JOLOKIA_PORT = 8778;

    public Datagrid(boolean withLivenessProbe, boolean withReadinessProbe) {
        this("datagrid-app", "testdb", "testpwd123", "DATAGRID", null, withLivenessProbe, withReadinessProbe, "hotrod,memcached,rest", "default,test", "", "datagrid-app-hotrod", "testpwd123", true);
    }

    public Datagrid(String appName) {
        this(appName, "testdb", "testpwd123", "DATAGRID", null, true, true, "hotrod,memcached,rest", "default,test", "", "datagrid-app-hotrod", "testpwd123", true);
    }

    public Datagrid(String appName, String username, String password, String connectors, String cacheNames, String datavirtCacheNames, String hotrodSvcName, String jgroupsPasswd, boolean createService) {
        this(appName, username, password, "DATAGRID", null, true, true, connectors, cacheNames, datavirtCacheNames, hotrodSvcName, jgroupsPasswd, createService);
    }

    public Datagrid(String appName, String username, String password, String symbolicName, String dataDir, boolean withLivenessProbe, boolean withReadinessProbe, String connectors, String cacheNames, String datavirtCacheNames, String hotrodSvcName, String jgroupsPasswd, boolean createService) {
        super(username, password, "testdb", symbolicName, dataDir, withLivenessProbe, withReadinessProbe);
        this.appName = appName;
        this.username = username;
        this.password = password;
        this.connectors = connectors;
        this.cacheNames = cacheNames;
        this.datavirtCacheNames = datavirtCacheNames;
        this.hotrodSvcName = hotrodSvcName;
        this.jgroupsPasswd = jgroupsPasswd;
        this.createService = createService;
    }

    @Override
    public String getImageName() {
        return ImageRegistry.get().jdg();
    }

    @Override
    public int getPort() {
        return 11333;
    }

    @Override
    public Map<String, String> getImageVariables() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("USERNAME", this.username);
        vars.put("PASSWORD", this.password);
        vars.put("OPENSHIFT_KUBE_PING_LABELS", "application=" + this.appName);
        vars.put("OPENSHIFT_KUBE_PING_NAMESPACE", TestConfiguration.masterNamespace());
        vars.put("INFINISPAN_CONNECTORS", this.connectors);
        vars.put("CACHE_NAMES", this.cacheNames);
        vars.put("DATAVIRT_CACHE_NAMES", this.datavirtCacheNames);
        vars.put("HOTROD_SERVICE_NAME", this.hotrodSvcName);
        vars.put("JGROUPS_CLUSTER_PASSWORD", this.jgroupsPasswd);
        vars.put("ENV_FILES", "/etc/datagrid-environment/*");
        return vars;
    }

    @Override
    protected void configureContainer(ContainerBuilder containerBuilder) {
        if (this.withLivenessProbe) {
            containerBuilder.addLivenessProbe().setInitialDelay(30).createExecProbe("/bin/sh", "-c", "/opt/datagrid/bin/livenessProbe.sh");
        }
        if (this.withReadinessProbe) {
            containerBuilder.addReadinessProbe().setInitialDelaySeconds(5).createExecProbe("/bin/sh", "-c", "/opt/datagrid/bin/readinessProbe.sh");
        }
        containerBuilder.port(8778, TransportProtocol.TCP, "jolokia");
    }

    @Override
    public void configureService(ApplicationBuilder appBuilder) {
        if (this.createService) {
            super.configureService(appBuilder);
        } else {
            ((ServiceBuilder)new ServiceBuilder(this.appName).addLabel("application", appBuilder.getName())).setPort(11333).setContainerPort(11333).useTCP().addContainerSelector("name", this.appName);
        }
    }
}

