/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openstack;

import cz.xtf.TestConfiguration;
import cz.xtf.docker.OpenShiftNode;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.compute.Action;
import org.openstack4j.model.compute.RebootType;
import org.openstack4j.model.compute.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftNodeOnOpenStack
extends OpenShiftNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenShiftNode.class);
    private final Server openStackServer;
    private final OSClient openStackClient;

    public OpenShiftNodeOnOpenStack(String hostname, Server openStackServer, OSClient openStackClient) {
        super(hostname);
        this.openStackServer = openStackServer;
        this.openStackClient = openStackClient;
    }

    public OpenShiftNodeOnOpenStack(OpenShiftNode node, Server openStackServer, OSClient openStackClient) {
        super(node.getHostname(), node.getStatus(), node.getLabels());
        this.openStackServer = openStackServer;
        this.openStackClient = openStackClient;
    }

    public void hardRestart() {
        LOGGER.info("Hard-restart of node {}, {}", (Object)this.getHostname(), (Object)this.openStackServer.getName());
        this.openStackClient.compute().servers().reboot(this.openStackServer.getId(), RebootType.HARD);
    }

    public void powerOff() {
        LOGGER.info("Powering off node {}, {}", (Object)this.getHostname(), (Object)this.openStackServer.getName());
        this.openStackClient.compute().servers().action(this.openStackServer.getId(), Action.STOP);
    }

    public void boot() {
        LOGGER.info("Booting up node {}, {}", (Object)this.getHostname(), (Object)this.openStackServer.getName());
        this.openStackClient.compute().servers().action(this.openStackServer.getId(), Action.START);
    }

    public void pause() {
        LOGGER.info("Pausing node {}, {}", (Object)this.getHostname(), (Object)this.openStackServer.getName());
        this.openStackClient.compute().servers().action(this.openStackServer.getId(), Action.PAUSE);
    }

    public void resume() {
        LOGGER.info("Resuming node {}, {}", (Object)this.getHostname(), (Object)this.openStackServer.getName());
        this.openStackClient.compute().servers().action(this.openStackServer.getId(), Action.RESUME);
    }

    public void networkDown() {
        LOGGER.info("Disabling network for {}, {}", (Object)this.getHostname(), (Object)this.openStackServer.getName());
        this.openStackClient.compute().servers().removeSecurityGroup(this.openStackServer.getId(), TestConfiguration.openStackOpenSecurityGroup());
    }

    public void networkUp() {
        LOGGER.info("Enabling network for {}, {}", (Object)this.getHostname(), (Object)this.openStackServer.getName());
        this.openStackClient.compute().servers().addSecurityGroup(this.openStackServer.getId(), TestConfiguration.openStackOpenSecurityGroup());
    }

    @Override
    public String toString() {
        return super.toString() + ", on OpenStack node " + this.openStackServer.getName();
    }
}

