/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openstack;

import cz.xtf.TestConfiguration;
import cz.xtf.docker.OpenShiftNode;
import cz.xtf.openshift.OpenshiftUtil;
import cz.xtf.openstack.OpenShiftNodeOnOpenStack;
import cz.xtf.tuple.Tuple;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openstack4j.api.OSClient;
import org.openstack4j.api.client.IOSClientBuilder;
import org.openstack4j.model.compute.Server;
import org.openstack4j.openstack.OSFactory;

public class OpenStackService {
    private final OSClient openStack = (OSClient)((IOSClientBuilder.V2)((IOSClientBuilder.V2)OSFactory.builder().endpoint(TestConfiguration.openStackURL())).credentials(TestConfiguration.openStackUsername(), TestConfiguration.openStackPassword())).tenantName(TestConfiguration.openStackTenant()).authenticate();

    public List<? extends Server> getOpenStackNodes() {
        return this.openStack.compute().servers().list();
    }

    public List<OpenShiftNodeOnOpenStack> getOpenShiftNodes(List<OpenShiftNode> openShiftNodes) {
        List<? extends Server> osNodes = this.getOpenStackNodes();
        Map<String, String> hostToIP = openShiftNodes.stream().map(openShiftNode -> openShiftNode.getHostname()).map(x -> {
            try {
                return Arrays.asList(InetAddress.getAllByName(x)).stream();
            }
            catch (Exception e) {
                return null;
            }
        }).flatMap(x -> x).collect(Collectors.toMap(x -> x.getHostName(), x -> x.getHostAddress()));
        Map<String, Server> ipToOpenStackNode = osNodes.stream().flatMap(node -> node.getAddresses().getAddresses().values().stream().flatMap(addresses -> addresses.stream()).map(x -> Tuple.pair(x.getAddr(), node))).collect(Collectors.toMap(x -> (String)x.getFirst(), x -> (Server)x.getSecond()));
        return openShiftNodes.stream().filter(x -> hostToIP.containsKey(x.getHostname())).filter(x -> ipToOpenStackNode.containsKey(hostToIP.get(x.getHostname()))).map(x -> new OpenShiftNodeOnOpenStack((OpenShiftNode)x, (Server)ipToOpenStackNode.get(hostToIP.get(x.getHostname())), this.openStack)).collect(Collectors.toList());
    }

    public List<OpenShiftNodeOnOpenStack> getOpenShiftNodes() {
        return this.getOpenShiftNodes(OpenshiftUtil.getInstance().getNodes());
    }

    @SafeVarargs
    public final List<OpenShiftNodeOnOpenStack> getOpenShiftNodes(Tuple.Pair<String, String> ... labels) {
        return this.getOpenShiftNodes(OpenshiftUtil.getInstance().getNodes(labels));
    }

    public void connectAllNodesToNetwork() {
        this.getOpenShiftNodes().forEach(x -> x.networkUp());
    }
}

