/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.sso.util;

import cz.xtf.wait.WaitUtil;
import java.util.concurrent.TimeoutException;
import java.util.function.BooleanSupplier;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public class DriverUtil {
    public static void login(WebDriver driver, String username, String password) throws TimeoutException, InterruptedException {
        DriverUtil.waitFor(driver, By.id((String)"username"), By.id((String)"password"), By.id((String)"kc-login"));
        driver.findElement(By.id((String)"username")).sendKeys(new CharSequence[]{username});
        driver.findElement(By.id((String)"password")).sendKeys(new CharSequence[]{password});
        driver.findElement(By.id((String)"kc-login")).click();
        Thread.sleep(5000L);
    }

    public static void waitFor(WebDriver driver, By ... elements) throws TimeoutException, InterruptedException {
        DriverUtil.waitFor(driver, 60000L, elements);
    }

    public static void waitFor(WebDriver driver, long timeout, By ... elements) throws TimeoutException, InterruptedException {
        try {
            WaitUtil.waitFor(() -> DriverUtil.elementsPresent(driver, elements), null, 1000L, timeout);
        }
        catch (TimeoutException ex) {
            try {
                for (By element : elements) {
                    WebElement webElement = driver.findElement(element);
                    if (webElement.isDisplayed()) continue;
                    throw new TimeoutException("Timeout exception during waiting for web element: " + webElement.getText());
                }
            }
            catch (NoSuchElementException | StaleElementReferenceException x) {
                throw new TimeoutException("Timeout exception during waiting for web element: " + x.getMessage());
            }
        }
    }

    public static void buttonClick(WebDriver driver, By element) {
        driver.findElement(element).click();
    }

    public static void comboBoxSelectItem(WebDriver driver, By element, String item) {
        Select comboBox = new Select(driver.findElement(element));
        comboBox.selectByVisibleText(item);
    }

    public static BooleanSupplier textAppears(WebDriver driver, By element, String text) {
        return () -> {
            try {
                return text.equalsIgnoreCase(driver.findElement(element).getText());
            }
            catch (Exception x) {
                return false;
            }
        };
    }

    public static boolean elementsPresent(WebDriver driver, By ... elements) {
        try {
            for (By element : elements) {
                WebElement webElement = driver.findElement(element);
                if (webElement.isDisplayed()) continue;
                return false;
            }
            return true;
        }
        catch (NoSuchElementException | StaleElementReferenceException x) {
            return false;
        }
    }
}

