/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.tuple;

import java.io.Serializable;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class Tuple {
    public static <X, Y> Pair<X, Y> pair(X x, Y y) {
        return new PairImpl<X, Y>(x, y);
    }

    public static <T, W> Function<Pair<T, W>, Pair<T, W>> pairBinarizeFirst(BiFunction<T, W, W> func) {
        return p -> {
            Object w = func.apply(p.getFirst(), p.getSecond());
            return Tuple.pair(p.getFirst(), w);
        };
    }

    public static <T, W> Function<Pair<T, W>, Pair<T, W>> pairIgnoreFirst(Function<W, W> func) {
        return p -> {
            Object w = func.apply(p.getSecond());
            return Tuple.pair(p.getFirst(), w);
        };
    }

    public static <T, W> Function<Pair<T, W>, Pair<T, W>> pairConsumeSecond(Consumer<W> func) {
        return p -> {
            func.accept(p.getSecond());
            return p;
        };
    }

    public static <X, Y, Z> Triple<X, Y, Z> triple(X x, Y y, Z z) {
        return new TripleImpl<X, Y, Z>(x, y, z);
    }

    public static class TripleImpl<X, Y, Z>
    implements Triple<X, Y, Z> {
        private static final long serialVersionUID = 4035047312787547257L;
        private X first;
        private Y second;
        private Z third;

        public TripleImpl(X x, Y y, Z z) {
            this.first = x;
            this.second = y;
            this.third = z;
        }

        @Override
        public X getFirst() {
            return this.first;
        }

        @Override
        public Y getSecond() {
            return this.second;
        }

        @Override
        public Z getThird() {
            return this.third;
        }

        public String toString() {
            return "(" + this.first + ", " + this.second + ", " + this.third + ")";
        }
    }

    public static class PairImpl<X, Y>
    implements Pair<X, Y> {
        private static final long serialVersionUID = -114609472475893593L;
        private X first;
        private Y second;

        public PairImpl(X x, Y y) {
            this.first = x;
            this.second = y;
        }

        @Override
        public X getFirst() {
            return this.first;
        }

        @Override
        public Y getSecond() {
            return this.second;
        }

        public String toString() {
            return "(" + this.first + ", " + this.second + ")";
        }
    }

    public static interface Triple<X, Y, Z>
    extends Serializable {
        public X getFirst();

        public Y getSecond();

        public Z getThird();
    }

    public static interface Pair<X, Y>
    extends Serializable {
        public X getFirst();

        public Y getSecond();
    }
}

