/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.yaml;

import cz.xtf.TestParent;
import cz.xtf.docker.OpenShiftNode;
import cz.xtf.git.GitProject;
import cz.xtf.http.HttpClient;
import cz.xtf.openshift.OpenshiftApplication;
import cz.xtf.openshift.OpenshiftUtil;
import cz.xtf.openshift.builder.ApplicationBuilder;
import cz.xtf.openshift.builder.DeploymentConfigBuilder;
import cz.xtf.openshift.builder.PodBuilder;
import cz.xtf.openshift.builder.RouteBuilder;
import cz.xtf.openshift.builder.pod.ContainerBuilder;
import cz.xtf.openshift.db.AbstractDatabase;
import cz.xtf.yaml.YamlParser;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YamlDeployer {
    private static final Logger LOGGER = LoggerFactory.getLogger(YamlDeployer.class);
    private static final OpenshiftUtil OPENSHIFT = OpenshiftUtil.getInstance();
    private static final boolean RECREATE_BY_DEFAULT = false;
    private YamlParser config;
    private ApplicationBuilder appBuilder;
    private ContainerBuilder containerBuilder;
    private final String appName;
    private final String image;
    private final String testSuite;

    public YamlDeployer(String fileLocation) throws Exception {
        this(fileLocation, null, false);
    }

    public YamlDeployer(String fileLocation, boolean recreateProject) throws Exception {
        this(fileLocation, null, recreateProject);
    }

    public YamlDeployer(String fileLocation, String appName) throws Exception {
        this(fileLocation, appName, false);
    }

    public YamlDeployer(String fileLocation, String appName, boolean recreateProject) throws Exception {
        OPENSHIFT.createProject(OPENSHIFT.getContext().getNamespace(), recreateProject);
        this.config = new YamlParser(fileLocation, appName);
        this.appName = this.config.getAppName();
        this.image = this.config.getImage();
        this.testSuite = this.config.getTestSuite();
        this.setup();
    }

    private void setup() throws Exception {
        switch (this.config.getBuildStrategy()) {
            case "none": {
                this.setupPureDeployment();
                break;
            }
            case "S2I": {
                this.setupS2I();
                break;
            }
            case "Docker": {
                this.setupDocker();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown build strategy: " + this.config.getBuildStrategy());
            }
        }
    }

    private void setupPureDeployment() throws Exception {
        LOGGER.info("Setting up pure deployment...");
        this.appBuilder = new ApplicationBuilder(this.appName);
        this.appBuilder.imageStream().fromExternalImage(this.image).addLabel("application", this.appName);
        this.setCommon();
        this.containerBuilder.fromImage(this.image);
    }

    private void setupS2I() throws Exception {
        LOGGER.info("Running S2I setup...");
        String projectPath = this.config.getProject();
        TestParent.gitlab().deleteProject(projectPath);
        GitProject project = TestParent.gitlab().createProjectFromPath(projectPath, this.config.getAppDirectory());
        this.appBuilder = new ApplicationBuilder(this.appName, project.getHttpUrl(), this.image);
        this.setCommon();
    }

    private void setupDocker() {
        throw new UnsupportedOperationException("Docker build strategy not yet implemented by Yaml deployer");
    }

    private void setCommon() throws Exception {
        this.containerBuilder = ((PodBuilder)((DeploymentConfigBuilder)this.appBuilder.deploymentConfig(this.appName, this.appName, false).onConfigurationChange().addLabel("application", this.appName)).setReplicas(this.config.getReplicas()).podTemplate().addLabel("application", this.appName)).container(this.appName);
        List<AbstractDatabase> databases = this.config.getDatabases();
        if (databases != null && databases.size() > 0) {
            this.appBuilder.addDatabases(databases.toArray(new AbstractDatabase[databases.size()]));
        }
        this.config.getEnviroments().forEach((k, v) -> this.containerBuilder.envVar((String)k, (String)v));
        this.setServices();
        this.setRoutes();
    }

    private void setServices() throws Exception {
        Class<?> productService = YamlDeployer.class.getClassLoader().loadClass("cz.xtf.openshift.xtfservices." + this.testSuite.toUpperCase() + "Services");
        for (String s : this.config.getServices()) {
            productService.getDeclaredMethod("add" + s + "Service", ApplicationBuilder.class, String.class).invoke(productService, this.appBuilder, this.appName);
        }
    }

    private void setRoutes() throws Exception {
        Class<?> productRoute = YamlDeployer.class.getClassLoader().loadClass("cz.xtf.openshift.xtfservices." + this.testSuite.toUpperCase() + "Services");
        for (String r : this.config.getRoutes()) {
            productRoute.getDeclaredMethod("add" + r + "Route", ApplicationBuilder.class, String.class).invoke(productRoute, this.appBuilder, this.appName);
        }
    }

    public void build() {
        OpenshiftApplication app = new OpenshiftApplication(this.appBuilder);
        app.triggerManualBuild();
    }

    public YamlDeployer deploy() {
        OpenshiftApplication app = new OpenshiftApplication(this.appBuilder);
        if (this.config.getBuildStrategy().equals("none")) {
            app.deployWithoutBuild();
        } else {
            app.deploy();
        }
        return this;
    }

    public void delete() {
        OpenShiftNode.master().executeCommand(String.format("sudo oc -n %s delete dc,svc,routes,is -l application=%s", OPENSHIFT.getContext().getNamespace(), this.appName));
    }

    public void waitForDeploymentReady() throws Exception {
        for (Map.Entry<String, List<String>> entry : this.config.getWaitRules().entrySet()) {
            this.waitTillReady(entry.getKey(), entry.getValue());
        }
    }

    private void waitTillReady(String waitCondition, List<String> addresses) throws Exception {
        block6: for (String address : addresses) {
            String waitAddress = address.replace("defaultRoute", RouteBuilder.createHostName(this.appName));
            switch (waitCondition) {
                case "httpOK": {
                    LOGGER.debug("Waiting for HTTP_OK: {}", (Object)waitAddress);
                    HttpClient.get(waitAddress).waitForOk(3L, TimeUnit.MINUTES);
                    continue block6;
                }
            }
            throw new UnsupportedOperationException("Unsupported wait condition: " + waitCondition);
        }
    }

    public ApplicationBuilder getAppBuilder() {
        return this.appBuilder;
    }

    public ContainerBuilder getContainerBuilder() {
        return this.containerBuilder;
    }

    public YamlParser getConfig() {
        return this.config;
    }
}

