/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.yaml;

import cz.xtf.TestParent;
import cz.xtf.openshift.OpenshiftUtil;
import cz.xtf.openshift.db.AbstractDatabase;
import cz.xtf.openshift.db.MongoDB;
import cz.xtf.openshift.db.MySQL;
import cz.xtf.openshift.db.PostgreSQL;
import cz.xtf.openshift.imagestream.ImageRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class YamlParser {
    private Map<String, Object> appData;
    private final String appName;
    private final String image;
    private final String testSuite;
    private final String buildStrategy;
    private final String projectName;
    private final Path appDirectory;
    private final int replicas;
    private final Map<String, String> enviroments;
    private final Map<String, List<String>> waitRules;
    private final List<String> services;
    private final List<String> routes;
    private final List<AbstractDatabase> databases;

    public YamlParser(String yamlApp) throws Exception {
        this(yamlApp, null);
    }

    public YamlParser(String yamlApp, String appName) throws Exception {
        FileInputStream is = new FileInputStream(new File(yamlApp));
        this.appData = (HashMap)new Yaml().load((InputStream)is);
        ((InputStream)is).close();
        this.appName = this.initAppName(appName);
        this.image = this.initImage();
        this.testSuite = this.initTestSuite();
        this.buildStrategy = this.initBuildStrategy();
        this.projectName = this.initProject();
        this.appDirectory = this.initAppDirectory();
        this.replicas = this.initReplicas();
        this.enviroments = this.initEnviroments();
        this.waitRules = this.initWaitRules();
        this.services = this.initServices();
        this.routes = this.initRoutes();
        this.databases = this.initDatabases();
        this.replaceDynamic();
    }

    private String initAppName(String appName) {
        return appName != null ? appName : this.appData.get("name").toString();
    }

    private String initImage() throws Exception {
        String image = this.appData.get("image").toString();
        if (image == null) {
            throw new Exception("No image defined! Define image to use, e.g.:\nimage: eap");
        }
        return ImageRegistry.get().getClass().getDeclaredMethod(image, new Class[0]).invoke((Object)ImageRegistry.get(), new Object[0]).toString();
    }

    private String initTestSuite() throws Exception {
        if (this.appData.get("testSuite") == null) {
            throw new Exception("No testSuite definded! Define testSuite, e.g.:\ntestSuite: ews");
        }
        return this.appData.get("testSuite").toString();
    }

    private String initBuildStrategy() {
        return this.appData.get("build") == null ? "none" : this.appData.get("build").toString();
    }

    private String initProject() {
        return this.appData.get("project") == null ? null : this.appData.get("project").toString();
    }

    private Path initAppDirectory() {
        return this.projectName == null ? null : TestParent.findApplicationDirectory(this.testSuite, this.projectName);
    }

    private int initReplicas() {
        return this.appData.get("replicas") != null ? (Integer)this.appData.get("replicas") : 1;
    }

    private Map<String, String> initEnviroments() {
        if (this.appData.get("envs") == null) {
            return new HashMap<String, String>();
        }
        return (HashMap)this.appData.get("envs");
    }

    private Map<String, List<String>> initWaitRules() {
        if (this.appData.get("waitFor") == null) {
            return new HashMap<String, List<String>>();
        }
        return (HashMap)this.appData.get("waitFor");
    }

    private List<String> initServices() {
        if (this.appData.get("services") == null) {
            return new ArrayList<String>();
        }
        return (ArrayList)this.appData.get("services");
    }

    private List<String> initRoutes() {
        if (this.appData.get("routes") == null) {
            return new ArrayList<String>();
        }
        return (ArrayList)this.appData.get("routes");
    }

    private List<AbstractDatabase> initDatabases() throws Exception {
        if (this.appData.get("databases") == null) {
            return null;
        }
        ArrayList<AbstractDatabase> dbs = new ArrayList<AbstractDatabase>();
        Iterator iterator = ((ArrayList)this.appData.get("databases")).iterator();
        block10: while (iterator.hasNext()) {
            String db;
            switch (db = (String)iterator.next()) {
                case "PostgreSQL": {
                    dbs.add(new PostgreSQL());
                    continue block10;
                }
                case "MySQL": {
                    dbs.add(new MySQL());
                    continue block10;
                }
                case "MongoDB": {
                    dbs.add(new MongoDB());
                    continue block10;
                }
            }
            throw new UnsupportedOperationException("Unsupported database: " + db);
        }
        return dbs;
    }

    private void replaceDynamic() {
        this.enviroments.forEach((k, v) -> {
            if (v.equals("namespace")) {
                this.enviroments.put((String)k, OpenshiftUtil.getInstance().getContext().getNamespace());
            }
        });
    }

    String getAppName() {
        return this.appName;
    }

    String getImage() {
        return this.image;
    }

    String getTestSuite() {
        return this.testSuite;
    }

    String getBuildStrategy() {
        return this.buildStrategy;
    }

    String getProject() {
        return this.projectName;
    }

    Path getAppDirectory() {
        return this.appDirectory;
    }

    public int getReplicas() {
        return this.replicas;
    }

    Map<String, String> getEnviroments() {
        return this.enviroments;
    }

    Map<String, List<String>> getWaitRules() {
        return this.waitRules;
    }

    List<String> getServices() {
        return this.services;
    }

    List<String> getRoutes() {
        return this.routes;
    }

    List<AbstractDatabase> getDatabases() {
        return this.databases;
    }
}

