/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.docker;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import cz.xtf.TestConfiguration;
import cz.xtf.io.IOUtils;
import cz.xtf.openshift.OpenshiftUtil;
import cz.xtf.ssh.SshUtil;
import io.fabric8.kubernetes.api.model.NodeCondition;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenShiftNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenShiftNode.class);
    private static OpenShiftNode master = null;
    private final String hostname;
    private final String username;
    private Map<String, String> labels = null;
    private Status status = null;

    public OpenShiftNode(String hostname) {
        this(hostname, null);
    }

    public OpenShiftNode(String hostname, Status status, Map<String, String> labels) {
        this(hostname, null);
        this.labels = labels;
        this.status = status;
    }

    public OpenShiftNode(String hostname, String username) {
        this.hostname = hostname;
        this.username = username == null ? TestConfiguration.masterSshUsername() : username;
    }

    public static OpenShiftNode master() {
        if (master != null) {
            return master;
        }
        master = new OpenShiftNode(URI.create(OpenshiftUtil.getInstance().getServer()).getHost());
        return master;
    }

    public static OpenShiftNode router() {
        return OpenShiftNode.master();
    }

    public int executeCommand(String command, CommandResultConsumer consumer) {
        return this.executeCommand(false, command, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeCommand(boolean setPty, String command, CommandResultConsumer consumer) {
        Session ssh = SshUtil.getInstance().createSshSession(this.username, this.hostname);
        int resultCode = 255;
        try {
            ssh.connect();
            LOGGER.debug("Connected to ssh console");
            ChannelExec channel = (ChannelExec)ssh.openChannel("exec");
            channel.setPty(setPty);
            channel.setCommand(command);
            channel.setInputStream(null);
            channel.setOutputStream((OutputStream)System.err);
            LOGGER.debug("Executing command: '{}'", (Object)command);
            channel.connect();
            try {
                if (consumer != null) {
                    consumer.consume(channel.getInputStream());
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to read console output", ex);
            }
            finally {
                channel.disconnect();
            }
            resultCode = channel.getExitStatus();
        }
        catch (JSchException x) {
            LOGGER.error("Error SSH to " + this.username + "@" + this.hostname, (Throwable)x);
        }
        finally {
            ssh.disconnect();
        }
        return resultCode;
    }

    public String executeCommand(String command) {
        AtomicReference aref = new AtomicReference();
        int result = this.executeCommand(true, command, stream -> aref.set(IOUtils.readInputStream(stream)));
        String ret = (String)aref.get();
        if (result != 0) {
            LOGGER.warn("Command '{}' exited with status {}", (Object)command, (Object)result);
            if (ret == null) {
                ret = "[null]";
            }
            LOGGER.warn("Result: '{}'", (Object)StringUtils.abbreviate((String)ret, (int)(ret.length() - 100), (int)100));
        }
        if (ret != null) {
            if (ret.length() > 80) {
                LOGGER.debug("Result: '{}...' (length: {})", (Object)ret.substring(0, 80), (Object)ret.length());
            } else {
                LOGGER.debug("Result: '{}'", (Object)ret);
            }
        }
        return (String)aref.get();
    }

    public void portForward(String targetHost, int targetPort, Consumer<Integer> code) {
        Session ssh = SshUtil.getInstance().createSshSession(this.username, this.hostname);
        try {
            int localPort = ssh.setPortForwardingL(0, targetHost, targetPort);
            ssh.connect();
            code.accept(localPort);
            LOGGER.debug("Doing port forward {}->{}", (Object)localPort, (Object)targetPort);
        }
        catch (JSchException x) {
            LOGGER.error("Error SSH to " + this.username + "@" + this.hostname, (Throwable)x);
            throw new IllegalStateException(x);
        }
        finally {
            ssh.disconnect();
        }
    }

    public void restart() {
        this.executeCommand("sudo reboot");
    }

    public void shutdown() {
        this.executeCommand("sudo shutdown -H now");
    }

    public boolean isSSHResponsive() {
        try {
            String testUser = this.executeCommand("whoami");
            return testUser != null && this.username.equals(testUser.trim());
        }
        catch (Exception e) {
            LOGGER.error("SSH ping exception", (Throwable)e);
            return false;
        }
    }

    public void ifDownAndUp(int seconds) {
        this.executeCommand("nohup sudo -b sh -c 'ifdown eth0; sleep " + seconds + "; ifup eth0'");
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getIPAddress() {
        try {
            return InetAddress.getByName(this.getHostname()).getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Cannot resolve hostname to IP", e);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isMaster() {
        return "master".equals(this.executeCommand("ls /etc/sysconfig/atomic-openshift-master > /dev/null && echo \"master\"").trim());
    }

    public boolean isDnsmasq() {
        return "dnsmasq".equals(this.executeCommand("netstat -tlnp | grep ':53 .*dnsmasq' > /dev/null && echo dnsmasq").trim());
    }

    public boolean isRouter() {
        return "router".equals(this.executeCommand("netstat -tlnp | grep ':80 .*docker-proxy' > /dev/null && echo router").trim());
    }

    public boolean isInfra() {
        return this.isMaster() || this.isDnsmasq() || this.isRouter();
    }

    public String toString() {
        return "[Node:" + this.username + "@" + this.hostname + "], status = " + (this.status != null ? this.status : "Not initialized") + ", labels = " + (this.labels != null ? this.labels : "Not initialized");
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Status getStatus() {
        return this.status;
    }

    public void waitTillNodeIsReady() {
        OpenShiftNode n;
        LOGGER.info("Waiting for node {} to go on-line", (Object)this.getHostname());
        while (!this.isSSHResponsive()) {
            LOGGER.debug("SSH not responsive");
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                LOGGER.error("Error in waiting", (Throwable)e);
                throw new IllegalStateException("Error in waiting", e);
            }
        }
        LOGGER.info("SSH responsive");
        while ((n = OpenshiftUtil.getInstance().getNodesAsMap().get(this.getHostname())).getStatus() != Status.Ready) {
            LOGGER.debug("Node on-line but not ready");
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                LOGGER.error("Error in waiting", (Throwable)e);
                throw new IllegalStateException("Error in waiting", e);
            }
        }
        LOGGER.info("Node {} ready", (Object)this.getHostname());
    }

    @FunctionalInterface
    public static interface CommandResultConsumer {
        public void consume(InputStream var1) throws IOException;
    }

    public static enum Status {
        Unknown,
        Ready,
        NotReady;


        public static Status parseString(List<NodeCondition> conditions) {
            for (NodeCondition nc : conditions) {
                if (!nc.getType().equals("Ready")) continue;
                if (nc.getStatus().equals("True")) {
                    return Ready;
                }
                return NotReady;
            }
            return Unknown;
        }
    }
}

