/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.junit.filter;

import cz.xtf.junit.annotation.release.SinceVersion;
import cz.xtf.junit.annotation.release.SkipFor;
import cz.xtf.junit.filter.ExclusionTestClassFilter;
import cz.xtf.openshift.imagestream.ImageRegistry;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinceVersionFilter
implements ExclusionTestClassFilter {
    private static final Logger log = LoggerFactory.getLogger(SinceVersionFilter.class);

    public static SinceVersionFilter instance() {
        return FilterHolder.FILTER;
    }

    private String getRegistryOrClassImage(String image) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (image.startsWith("$")) {
            return (String)this.getClass().getMethod(image.replace("$", ""), new Class[0]).invoke(null, new Object[0]);
        }
        return (String)ImageRegistry.class.getDeclaredMethod(image, new Class[0]).invoke((Object)ImageRegistry.get(), new Object[0]);
    }

    @Override
    public boolean exclude(Class<?> testClass) {
        SkipFor[] skipFors;
        SinceVersion[] sinceVersions;
        for (SinceVersion sinceVersion : sinceVersions = (SinceVersion[])testClass.getAnnotationsByType(SinceVersion.class)) {
            try {
                String sinceVersionVersion;
                String image = this.getRegistryOrClassImage(sinceVersion.image());
                if (!image.contains(sinceVersion.name()) || ImageRegistry.isVersionAtLeast(new BigDecimal(sinceVersionVersion = sinceVersion.since().split("-")[0]), image)) continue;
                if (!sinceVersion.jira().isEmpty()) {
                    log.info("Excluding test {} for {}, image {} ({}) stream containing {} must be of version at least {}", new Object[]{testClass.toString(), sinceVersion.jira(), image, sinceVersion.image(), sinceVersion.name(), sinceVersionVersion});
                } else {
                    log.debug("Excluding test {}, image {} ({}) stream containing {} must be of version at least {}", new Object[]{testClass.toString(), image, sinceVersion.image(), sinceVersion.name(), sinceVersionVersion});
                }
                return true;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.error("Error invoking during @SinceVersion processing", (Throwable)e);
            }
        }
        for (SkipFor skipFor : skipFors = (SkipFor[])testClass.getAnnotationsByType(SkipFor.class)) {
            try {
                String image = this.getRegistryOrClassImage(skipFor.image());
                if (!image.contains(skipFor.name())) continue;
                if (!skipFor.reason().isEmpty()) {
                    log.info("Excluding test {}: {} - image {} ({}) stream containing {}", new Object[]{testClass.toString(), skipFor.reason(), image, skipFor.image(), skipFor.name()});
                } else {
                    log.debug("Excluding test {} - image {} ({}) stream containing {}", new Object[]{testClass.toString(), image, skipFor.image(), skipFor.name()});
                }
                return true;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.error("Error invoking during @SkipFor processing", (Throwable)e);
            }
        }
        return false;
    }

    private static class FilterHolder {
        public static final SinceVersionFilter FILTER = new SinceVersionFilter();

        private FilterHolder() {
        }
    }
}

