/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.keystore;

import cz.xtf.io.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.crypto.KeyGenerator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.slf4j.LoggerFactory;

public class XTFKeyStore {
    public static final String SIGNER_CERTIFICATE = "xtf.ca";
    public static final String SIGNER_PASSWORD = "password";
    private static XTFKeyStore instance;
    private final KeyStore keystore;

    private XTFKeyStore(KeyStore keystore) {
        this.keystore = keystore;
    }

    public static XTFKeyStore newInstance() {
        try {
            return XTFKeyStore.newInstance(null, null);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to instantiate new KeyStore", ex);
        }
    }

    public static XTFKeyStore newInstance(InputStream source, String password) throws IOException {
        return XTFKeyStore.newInstance(source, password, "JKS");
    }

    public static XTFKeyStore newInstance(InputStream source, String password, String keystoreType) throws IOException {
        try {
            KeyStore ks = KeyStore.getInstance(keystoreType == null ? "JKS" : keystoreType);
            ks.load(source, password == null ? null : password.toCharArray());
            return new XTFKeyStore(ks);
        }
        catch (GeneralSecurityException ex) {
            throw new RuntimeException("Couldn't load keystore", ex);
        }
    }

    public static XTFKeyStore getInstance() {
        if (instance == null) {
            Path defaultKeystore = XTFKeyStore.findDefaultKeyStore();
            try (InputStream is = Files.newInputStream(defaultKeystore, new OpenOption[0]);){
                instance = XTFKeyStore.newInstance(is, "");
            }
            catch (IOException ex) {
                throw new RuntimeException("Couldn't load default keystore: " + defaultKeystore, ex);
            }
        }
        return instance;
    }

    private static Path findDefaultKeyStore() {
        return IOUtils.findProjectRoot().resolve("keystore");
    }

    public Collection<String> getAliases() {
        try {
            LinkedList<String> result = new LinkedList<String>();
            Enumeration<String> e = this.keystore.aliases();
            while (e.hasMoreElements()) {
                result.add(e.nextElement());
            }
            return result;
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Key store is not initialized", e);
        }
    }

    public String getCertificate(String alias) {
        try {
            Certificate certificate = this.keystore.getCertificate(alias);
            return this.convertObject(certificate);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Key store is not initialized", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not convert certificate " + alias, e);
        }
    }

    public String getKey(String alias) {
        return this.getKey(alias, SIGNER_PASSWORD);
    }

    public String getKey(String alias, String password) {
        try {
            Key key = this.keystore.getKey(alias, password.toCharArray());
            return this.convertObject(key);
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("Key store is not initialized", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not convert key " + alias, e);
        }
        catch (UnrecoverableKeyException e) {
            throw new IllegalArgumentException("Wrong password for key " + alias, e);
        }
    }

    public void addCertificateFromBase64String(String certificate) {
        try {
            this.keystore.setCertificateEntry("maven", CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(certificate.getBytes())));
        }
        catch (KeyStoreException | CertificateException e) {
            throw new IllegalStateException(e);
        }
    }

    public void addSelfSignedCertificate(String certificateAlias) {
        this.addSelfSignedCertificate(certificateAlias, "CN=xtf,OU=QE,O=xtf.cz,L=Brno,C=CZ", SIGNER_PASSWORD);
    }

    public void addSelfSignedCertificate(String certificateAlias, String dn, String password) {
        try {
            KeyPair keys = this.generateKeyPair();
            Calendar start = Calendar.getInstance();
            Calendar expiry = Calendar.getInstance();
            expiry.add(1, 1);
            X500Name name = new X500Name(dn);
            X509v3CertificateBuilder certificateBuilder = new X509v3CertificateBuilder(name, BigInteger.ONE, start.getTime(), expiry.getTime(), name, SubjectPublicKeyInfo.getInstance((Object)keys.getPublic().getEncoded()));
            ContentSigner signer = new JcaContentSignerBuilder("SHA1WithRSA").setProvider((Provider)new BouncyCastleProvider()).build(keys.getPrivate());
            X509CertificateHolder holder = certificateBuilder.build(signer);
            X509Certificate cert = new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider()).getCertificate(holder);
            KeyStore.PrivateKeyEntry entry = new KeyStore.PrivateKeyEntry(keys.getPrivate(), new Certificate[]{cert});
            this.keystore.setEntry(certificateAlias, entry, new KeyStore.PasswordProtection(password.toCharArray()));
        }
        catch (GeneralSecurityException | OperatorCreationException ex) {
            throw new RuntimeException("Unable to generate self-signed certificate", ex);
        }
    }

    public void addSignedCertificate(XTFKeyStore signerKeyStore, String signerAlias, String signerPassword, String dn, String certificateAlias, String password) {
        try {
            X509Certificate caCert = (X509Certificate)signerKeyStore.keystore.getCertificate(signerAlias);
            PrivateKey caKey = (PrivateKey)signerKeyStore.keystore.getKey(signerAlias, signerPassword.toCharArray());
            Calendar start = Calendar.getInstance();
            Calendar expiry = Calendar.getInstance();
            expiry.add(1, 1);
            KeyPair keyPair = this.generateKeyPair();
            X500Name certName = new X500Name(dn);
            X500Name issuerName = new X500Name(caCert.getSubjectDN().getName());
            X509v3CertificateBuilder certificateBuilder = new X509v3CertificateBuilder(issuerName, BigInteger.valueOf(System.nanoTime()), start.getTime(), expiry.getTime(), certName, SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded()));
            JcaX509ExtensionUtils u = new JcaX509ExtensionUtils();
            certificateBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)u.createAuthorityKeyIdentifier(caCert));
            certificateBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)u.createSubjectKeyIdentifier(keyPair.getPublic()));
            ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSA").setProvider((Provider)new BouncyCastleProvider()).build(caKey);
            X509CertificateHolder holder = certificateBuilder.build(signer);
            X509Certificate cert = new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider()).getCertificate(holder);
            KeyStore.PrivateKeyEntry entry = new KeyStore.PrivateKeyEntry(keyPair.getPrivate(), new Certificate[]{cert, caCert});
            this.keystore.setEntry(certificateAlias, entry, new KeyStore.PasswordProtection(password.toCharArray()));
        }
        catch (GeneralSecurityException | CertIOException | OperatorCreationException ex) {
            throw new RuntimeException("Unable to generate signed certificate", ex);
        }
    }

    public void addPrivateKey(String keyAlias, String certificateAlias) {
        this.addPrivateKey(keyAlias, certificateAlias, SIGNER_PASSWORD);
    }

    public void addPrivateKey(String keyAlias, String certificateAlias, String password) {
        keyAlias = String.format("%s (%s)", keyAlias, certificateAlias);
        try {
            Certificate[] certChain = this.keystore.getCertificateChain(certificateAlias);
            if (certChain == null) {
                LoggerFactory.getLogger(this.getClass()).warn("Could not find certificate");
                certChain = new Certificate[]{};
            }
            KeyStore.PrivateKeyEntry entry = new KeyStore.PrivateKeyEntry(this.generateKeyPair().getPrivate(), certChain);
            KeyStore.PasswordProtection protParam = new KeyStore.PasswordProtection(password.toCharArray());
            this.keystore.setEntry(keyAlias, entry, protParam);
        }
        catch (KeyStoreException | NoSuchAlgorithmException ex) {
            throw new RuntimeException("Unable to add new private key", ex);
        }
    }

    public void addSecretKey(String keyAlias, String certificateAlias, String password) {
        try {
            Certificate[] certChain = null;
            try {
                certChain = this.keystore.getCertificateChain(certificateAlias);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            Key key = this.generateKey("DES", 56);
            this.keystore.setKeyEntry(keyAlias, key, password.toCharArray(), certChain);
        }
        catch (KeyStoreException | NoSuchAlgorithmException ex) {
            throw new RuntimeException("Unable to add new secret key", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Path export() {
        Path outputPath = XTFKeyStore.findDefaultKeyStore();
        try (OutputStream output = Files.newOutputStream(outputPath, new OpenOption[0]);){
            this.export(output, "");
            Path path = outputPath;
            return path;
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to export keystore to default location.");
        }
    }

    public void export(OutputStream output, String password) throws IOException {
        try {
            this.keystore.store(output, password.toCharArray());
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Unable to export keystore", e);
        }
    }

    /*
     * Exception decompiling
     */
    private String convertObject(Object obj) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Key generateKey(String algorithm, int keysize) throws NoSuchAlgorithmException, InvalidParameterException {
        KeyGenerator keyGen = KeyGenerator.getInstance(algorithm);
        keyGen.init(keysize);
        return keyGen.generateKey();
    }

    private KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(1024, new SecureRandom());
        return keyGen.generateKeyPair();
    }
}

