/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openshift;

import cz.xtf.openshift.OpenShiftBinaryClient;
import cz.xtf.openshift.OpenshiftUtil;
import io.fabric8.kubernetes.api.model.Pod;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodService
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PodService.class);
    private final Pod pod;
    private final OpenShiftBinaryClient oc = OpenShiftBinaryClient.getInstance();
    private Process runningProcess;

    public PodService(Pod pod) {
        this.pod = pod;
        this.oc.project(OpenshiftUtil.getInstance().getContext().getNamespace());
    }

    public void rsync(Path localDir, String remoteDir, RSyncStrategy strategy, String includes, boolean toPod) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("rsync");
        if (strategy != null) {
            args.add("--strategy");
            args.add(strategy.toString());
        }
        if (includes != null) {
            args.add("--include");
            args.add(includes);
        }
        args.add(!toPod ? this.pod.getMetadata().getName() + ":" + remoteDir + "/" : localDir.toFile().getAbsoluteFile().getPath() + "/");
        args.add(toPod ? this.pod.getMetadata().getName() + ":" + remoteDir + "/" : localDir.toFile().getAbsoluteFile().getPath() + "/");
        this.oc.executeCommand("rsync has failed", args.toArray(new String[args.size()]));
    }

    public void rsyncTo(Path localDir, String remoteDir, String includes) {
        this.rsync(localDir, remoteDir, RSyncStrategy.tar, includes, true);
    }

    public void rsyncFrom(Path localDir, String remoteDir, String includes) {
        this.rsync(localDir, remoteDir, RSyncStrategy.tar, includes, false);
    }

    public int portForward(int localPort, int remotePort) {
        if (this.runningProcess != null && this.runningProcess.isAlive()) {
            throw new IllegalStateException("Another process running " + this.runningProcess);
        }
        this.runningProcess = this.oc.executeCommandNoWait("port-forward has failed", "port-forward", this.pod.getMetadata().getName(), localPort + ":" + remotePort);
        return localPort;
    }

    public int portForward(int remotePort) throws InterruptedException, TimeoutException {
        if (this.runningProcess != null && this.runningProcess.isAlive()) {
            throw new IllegalStateException("Another process running " + this.runningProcess);
        }
        this.runningProcess = this.oc.executeCommandNoWaitWithOutputAndError("port-forward has failed", "port-forward", this.pod.getMetadata().getName(), ":" + remotePort);
        Pattern pattern = Pattern.compile("Forwarding from 127.0.0.1:(\\d+) -> (\\d)+");
        Semaphore s = new Semaphore(0);
        AtomicInteger port = new AtomicInteger(0);
        ExecutorService outputSucker = Executors.newFixedThreadPool(2);
        outputSucker.submit(() -> {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(this.runningProcess.getErrorStream(), "UTF-8"));
                while ((line = br.readLine()) != null) {
                    Matcher matcher;
                    LOGGER.debug("oc port-forward stderr: " + line);
                    if (port.get() != 0 || !(matcher = pattern.matcher(line)).find()) continue;
                    port.set(Integer.parseInt(matcher.group(1)));
                    LOGGER.debug("oc port-forward stderr, read local port: " + port.get());
                    s.release();
                }
                LOGGER.debug("port forward stderr sucker ending");
            }
            catch (IOException x) {
                LOGGER.error("Error reading output of 'oc port-forward' stderr", (Throwable)x);
            }
        });
        outputSucker.submit(() -> {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(this.runningProcess.getInputStream(), "UTF-8"));
                while ((line = br.readLine()) != null) {
                    Matcher matcher;
                    LOGGER.debug("oc port-forward stdout: " + line);
                    if (port.get() != 0 || !(matcher = pattern.matcher(line)).find()) continue;
                    port.set(Integer.parseInt(matcher.group(1)));
                    LOGGER.debug("oc port-forward stdout, read local port: " + port.get());
                    s.release();
                }
                LOGGER.debug("port forward stdout sucker ending");
            }
            catch (IOException x) {
                LOGGER.error("Error reading output of 'oc port-forward' stdout", (Throwable)x);
            }
        });
        outputSucker.shutdown();
        if (!s.tryAcquire(1L, TimeUnit.MINUTES)) {
            throw new TimeoutException("Didn't read the port in 60 seconds!");
        }
        return port.get();
    }

    public String exec(String ... command) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("exec");
        args.add(this.pod.getMetadata().getName());
        args.add("--");
        args.addAll(Arrays.asList(command));
        return this.oc.executeCommandWithReturn("remote execution has failed", args.toArray(new String[args.size()]));
    }

    public void execAndConsume(OpenShiftBinaryClient.CommandResultConsumer consumer, String ... command) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("exec");
        args.add(this.pod.getMetadata().getName());
        args.add("--");
        args.addAll(Arrays.asList(command));
        this.oc.executeCommandAndConsumeOutput("remote execution has failed", consumer, args.toArray(new String[args.size()]));
    }

    @Override
    public void close() throws Exception {
        if (this.runningProcess != null) {
            this.runningProcess.destroyForcibly();
            this.runningProcess = null;
        }
    }

    public static enum RSyncStrategy {
        rsync,
        tar;

    }
}

