/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openshift.builder;

import cz.xtf.TestConfiguration;
import cz.xtf.build.BuildDefinition;
import cz.xtf.build.BuildManagerV2;
import cz.xtf.build.XTFBuild;
import cz.xtf.openshift.OpenShiftAuxiliary;
import cz.xtf.openshift.OpenshiftApplication;
import cz.xtf.openshift.builder.BuildConfigBuilder;
import cz.xtf.openshift.builder.ConfigMapWithPropertyFilesBuilder;
import cz.xtf.openshift.builder.DeploymentConfigBuilder;
import cz.xtf.openshift.builder.ImageStreamBuilder;
import cz.xtf.openshift.builder.RouteBuilder;
import cz.xtf.openshift.builder.SecretBuilder;
import cz.xtf.openshift.builder.ServiceBuilder;
import cz.xtf.openshift.builder.buildconfig.SourceBuildStrategy;
import cz.xtf.openshift.builder.pod.ContainerBuilder;
import cz.xtf.openshift.external.ExternalService;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerBuilder;
import io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerFluent;
import io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerSpecFluent;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.Route;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationBuilder.class);
    private final String applicationName;
    private boolean sslEnabled = false;
    private final Set<RouteBuilder> routes = new HashSet<RouteBuilder>();
    private final Set<ServiceBuilder> services = new HashSet<ServiceBuilder>();
    private final Set<ImageStreamBuilder> images = new HashSet<ImageStreamBuilder>();
    private final Set<DeploymentConfigBuilder> deployments = new HashSet<DeploymentConfigBuilder>();
    private final Set<BuildConfigBuilder> builds = new HashSet<BuildConfigBuilder>();
    private final Map<String, SecretBuilder> secrets = new HashMap<String, SecretBuilder>();
    private List<ExternalService> externalServices = new ArrayList<ExternalService>();
    private final Set<ConfigMapWithPropertyFilesBuilder> configMaps = new HashSet<ConfigMapWithPropertyFilesBuilder>();
    private SourceBuildStrategy s2iStrategy;
    private Optional<AutoScaleConfig> autoScale = Optional.empty();

    public ApplicationBuilder(String name) {
        this.applicationName = name;
    }

    public ApplicationBuilder(String name, String gitRepo, String baseImage, boolean useMavenProxy) {
        this(name);
        this.imageStream().addLabel("name", this.applicationName);
        this.s2iStrategy = this.buildConfig().gitSource(gitRepo).setOutput(this.applicationName + "-image").sti().forcePull(true).fromDockerImage(baseImage);
        if (useMavenProxy) {
            this.s2iStrategy.addEnvVariable("MAVEN_MIRROR_URL", TestConfiguration.mavenProxyURL());
        }
        this.deploymentConfig();
        this.service().setContainerPort(8080);
        this.route();
    }

    public ApplicationBuilder(String name, String gitRepo, String baseImage) {
        this(name, gitRepo, baseImage, TestConfiguration.mavenProxyEnabled());
    }

    public ApplicationBuilder(String name, XTFBuild build) {
        this(name, build.getBuildDefinition());
    }

    public ApplicationBuilder(String name, BuildDefinition build) {
        this(name);
        BuildManagerV2.get().deployBuild(build);
        this.deploymentConfig(this.applicationName).onConfigurationChange().podTemplate().container().fromImage(TestConfiguration.buildNamespace(), build.getName()).port(8080);
        this.service().setContainerPort(8080);
        this.route();
    }

    public String getName() {
        return this.applicationName;
    }

    public ImageStreamBuilder imageStream() {
        return this.imageStream(this.applicationName + "-image");
    }

    public ImageStreamBuilder imageStream(String name) {
        ImageStreamBuilder builder;
        Optional<ImageStreamBuilder> orig = this.images.stream().filter(b -> b.getName().equals(name)).findFirst();
        if (orig.isPresent()) {
            LOGGER.debug("Trying to create image stream that already exists.");
            builder = orig.get();
        } else {
            builder = new ImageStreamBuilder(this, name);
            this.images.add(builder);
        }
        return builder;
    }

    public BuildConfigBuilder buildConfig() {
        return this.buildConfig(this.applicationName + "-build");
    }

    public BuildConfigBuilder buildConfig(String name) {
        BuildConfigBuilder builder;
        Optional<BuildConfigBuilder> orig = this.builds.stream().filter(b -> b.getName().equals(name)).findFirst();
        if (orig.isPresent()) {
            LOGGER.debug("Trying to create deployment config that already exists.");
            builder = orig.get();
        } else {
            builder = new BuildConfigBuilder(this, name);
            this.builds.add(builder);
        }
        return builder;
    }

    public DeploymentConfigBuilder deploymentConfig() {
        return this.deploymentConfig(this.applicationName);
    }

    public DeploymentConfigBuilder deploymentConfig(String name) {
        return this.deploymentConfig(name, this.applicationName, true);
    }

    public DeploymentConfigBuilder deploymentConfig(String name, String podName, boolean preConfigurePod) {
        DeploymentConfigBuilder builder;
        Optional<DeploymentConfigBuilder> orig = this.deployments.stream().filter(b -> b.getName().equals(name)).findFirst();
        if (orig.isPresent()) {
            LOGGER.debug("Trying to create deployment config that already exists.");
            builder = orig.get();
        } else {
            builder = new DeploymentConfigBuilder(this, name, podName);
            if (preConfigurePod) {
                builder.onConfigurationChange();
                ContainerBuilder container = builder.onImageChange().podTemplate().container();
                container.fromImage(this.imageStream().getName()).port(8080);
                if (this.sslEnabled) {
                    container.port(8443);
                }
            }
            this.deployments.add(builder);
        }
        return builder;
    }

    public ServiceBuilder service() {
        return this.service(this.applicationName + "-service");
    }

    public ServiceBuilder service(String serviceName) {
        return this.addService(serviceName, false);
    }

    public ServiceBuilder secureService() {
        return this.secureService(this.applicationName + "-secure-service");
    }

    public ServiceBuilder secureService(String serviceName) {
        this.sslEnabled = true;
        return this.addService(serviceName, true);
    }

    public RouteBuilder route() {
        return this.route(this.applicationName + "-route");
    }

    public RouteBuilder route(String routeName) {
        RouteBuilder result;
        Optional<RouteBuilder> orig = this.routes.stream().filter(r -> r.getName().startsWith(routeName)).findFirst();
        if (orig.isPresent()) {
            LOGGER.debug("Trying to create route that already exists.");
            result = orig.get();
        } else {
            result = new RouteBuilder(this, routeName);
            result.forService(this.applicationName + "-service");
            result.exposedAsHost(RouteBuilder.createHostName(this.applicationName));
            this.routes.add(result);
        }
        return result;
    }

    public ConfigMapWithPropertyFilesBuilder configMap() {
        return this.configMap(this.applicationName + "-cm");
    }

    public ConfigMapWithPropertyFilesBuilder configMap(String configMapName) {
        ConfigMapWithPropertyFilesBuilder result;
        Optional<ConfigMapWithPropertyFilesBuilder> orig = this.configMaps.stream().filter(r -> r.getName().equals(configMapName)).findFirst();
        if (orig.isPresent()) {
            LOGGER.debug("Trying to create configMap that already exists.");
            result = orig.get();
        } else {
            result = new ConfigMapWithPropertyFilesBuilder(configMapName);
            this.configMaps.add(result);
        }
        return result;
    }

    public List<ImageStream> buildImageStreams() {
        return this.images.stream().map(ImageStreamBuilder::build).collect(Collectors.toList());
    }

    public List<BuildConfig> buildBuildConfigs() {
        return this.builds.stream().map(BuildConfigBuilder::build).collect(Collectors.toList());
    }

    public List<DeploymentConfig> buildDeploymentConfigs() {
        return this.deployments.stream().map(DeploymentConfigBuilder::build).collect(Collectors.toList());
    }

    public List<Service> buildServices() {
        this.externalServices.stream().forEach(x -> x.configureService(this));
        return this.services.stream().map(ServiceBuilder::build).collect(Collectors.toList());
    }

    public List<Endpoints> buildEndpoints() {
        return this.externalServices.stream().map(x -> x.getEndpoints(this)).collect(Collectors.toList());
    }

    public List<Route> buildRoutes() {
        return this.routes.stream().map(RouteBuilder::build).collect(Collectors.toList());
    }

    public List<ConfigMap> buildConfigMaps() {
        return this.configMaps.stream().map(ConfigMapWithPropertyFilesBuilder::build).collect(Collectors.toList());
    }

    public List<HorizontalPodAutoscaler> buildAutoScalers() {
        return this.autoScale.map(x -> x == null ? Collections.EMPTY_LIST : Arrays.asList(x.build())).orElse(Collections.EMPTY_LIST);
    }

    public List<HasMetadata> build() {
        LinkedList<HasMetadata> result = new LinkedList<HasMetadata>();
        result.addAll(this.buildImageStreams());
        result.addAll(this.buildBuildConfigs());
        result.addAll(this.buildDeploymentConfigs());
        result.addAll(this.buildServices());
        result.addAll(this.buildRoutes());
        result.addAll(this.buildConfigMaps());
        this.autoScale.ifPresent(x -> result.add(x.build()));
        return result;
    }

    public OpenshiftApplication buildApplication() {
        return new OpenshiftApplication(this);
    }

    private ServiceBuilder addService(String serviceName, boolean secure) {
        ServiceBuilder result;
        Optional<ServiceBuilder> orig = this.services.stream().filter(b -> b.getName().equals(serviceName)).findFirst();
        if (orig.isPresent()) {
            LOGGER.debug("Trying to create service that already exists.");
            result = orig.get();
        } else {
            result = new ServiceBuilder(this, serviceName);
            result.addContainerSelector("name", this.applicationName);
            if (secure) {
                result.setPort(8443);
            }
            this.services.add(result);
        }
        return result;
    }

    public ApplicationBuilder addDatabases(OpenShiftAuxiliary ... databases) {
        Arrays.stream(databases).forEach(aux -> {
            aux.configureDeployment(this);
            aux.configureApplicationDeployment(this.deploymentConfig());
        });
        return this;
    }

    public ApplicationBuilder addExternalServices(ExternalService ... externalServices) {
        Collections.addAll(this.externalServices, externalServices);
        return this;
    }

    public List<Secret> getSecrets() {
        return this.secrets.values().stream().map(SecretBuilder::build).collect(Collectors.toList());
    }

    public Secret getSingleSecret() {
        if (this.secrets.size() != 1) {
            throw new IllegalArgumentException("Only one secret expected");
        }
        return this.getSecrets().get(0);
    }

    private SecretBuilder findSecretBuilder(String secretName) {
        SecretBuilder sb = this.secrets.get(secretName);
        if (sb == null) {
            sb = new SecretBuilder(secretName);
            this.secrets.put(secretName, sb);
        }
        return sb;
    }

    public ApplicationBuilder addSecret(String secretName, String name, byte[] value) {
        this.findSecretBuilder(secretName).addData(name, value);
        return this;
    }

    public ApplicationBuilder addSecret(String secretName, String name, InputStream value) {
        this.findSecretBuilder(secretName).addData(name, value);
        return this;
    }

    public ApplicationBuilder addSecret(String name, InputStream value) {
        return this.addSecret(name + "-secret", name, value);
    }

    public SourceBuildStrategy getS2iStrategy() {
        return this.s2iStrategy;
    }

    public ApplicationBuilder cpuAutoscale(int targetUtilization, int minReplicas, int maxReplicas) {
        this.autoScale = Optional.of(new AutoScaleConfig(targetUtilization, minReplicas, maxReplicas));
        return this;
    }

    private class AutoScaleConfig {
        private final int targetCPUUtilization;
        private final int minReplicas;
        private final int maxReplicas;

        public AutoScaleConfig(int targetCPUUtilization, int minReplicas, int maxReplicas) {
            this.targetCPUUtilization = targetCPUUtilization;
            this.minReplicas = minReplicas;
            this.maxReplicas = maxReplicas;
        }

        public HasMetadata build() {
            return ((HorizontalPodAutoscalerBuilder)((HorizontalPodAutoscalerFluent.SpecNested)((HorizontalPodAutoscalerFluent.SpecNested)((HorizontalPodAutoscalerFluent.SpecNested)((HorizontalPodAutoscalerFluent.SpecNested)((HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested)((HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested)((HorizontalPodAutoscalerBuilder)((HorizontalPodAutoscalerFluent.MetadataNested)new HorizontalPodAutoscalerBuilder().withNewMetadata().withName(ApplicationBuilder.this.applicationName)).endMetadata()).withNewSpec().withNewScaleTargetRef().withKind("DeploymentConfig")).withName(ApplicationBuilder.this.deploymentConfig().getName())).endScaleTargetRef()).withTargetCPUUtilizationPercentage(Integer.valueOf(this.targetCPUUtilization))).withMinReplicas(Integer.valueOf(this.minReplicas))).withMaxReplicas(Integer.valueOf(this.maxReplicas))).endSpec()).build();
        }
    }
}

