/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.openshift.messaging;

import cz.xtf.docker.DockerContainer;
import cz.xtf.docker.OpenShiftNode;
import cz.xtf.openshift.OpenShiftAuxiliary;
import cz.xtf.openshift.OpenshiftUtil;
import cz.xtf.openshift.VersionRegistry;
import cz.xtf.openshift.builder.ApplicationBuilder;
import cz.xtf.openshift.builder.DeploymentConfigBuilder;
import cz.xtf.openshift.builder.PodBuilder;
import cz.xtf.openshift.messaging.MessageBroker;
import io.fabric8.kubernetes.api.model.Pod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class HornetQCluster
implements OpenShiftAuxiliary,
MessageBroker {
    private static final String POD_LABEL = "hq-cluster";
    private static final String DEFAULT_CLUSTER_PASSWORD = "MyCluster*123";
    private List<String> queues = new ArrayList<String>();
    private List<String> topics = new ArrayList<String>();
    private String name;

    public HornetQCluster(String name) {
        this.name = name;
    }

    @Override
    public DeploymentConfigBuilder configureDeployment(ApplicationBuilder appBuilder, boolean synchronous) {
        return null;
    }

    @Override
    public void configureApplicationDeployment(DeploymentConfigBuilder dcBuilder) {
        String mqPrefix = VersionRegistry.get().eap().getMajorVersion().equals("6") ? "HORNETQ" : "MQ";
        ((PodBuilder)dcBuilder.podTemplate().addLabel(POD_LABEL, this.name)).container().envVar(mqPrefix + "_QUEUES", this.getQueueList()).envVar(mqPrefix + "_TOPICS", this.getTopicList()).envVar("HORNETQ_CLUSTER_PASSWORD", DEFAULT_CLUSTER_PASSWORD).envVar("OPENSHIFT_KUBE_PING_LABELS", "hq-cluster=" + this.name).envVar("OPENSHIFT_KUBE_PING_NAMESPACE", OpenshiftUtil.getInstance().getContext().getNamespace()).port(8888, "ping");
        OpenshiftUtil openshift = OpenshiftUtil.getInstance();
        OpenShiftNode.master().executeCommand(String.format("sudo oc policy add-role-to-user view system:serviceaccount:%s:default -n %s", openshift.getContext().getNamespace(), openshift.getContext().getNamespace()));
    }

    private String getTopicList() {
        return this.topics.stream().collect(Collectors.joining(","));
    }

    private String getQueueList() {
        return this.queues.stream().collect(Collectors.joining(","));
    }

    @Override
    public HornetQCluster withQueues(String ... queues) {
        Collections.addAll(this.queues, queues);
        return this;
    }

    @Override
    public HornetQCluster withTopics(String ... topics) {
        Collections.addAll(this.topics, topics);
        return this;
    }

    @Override
    public Pod getPod() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DockerContainer getContainer() {
        throw new UnsupportedOperationException();
    }
}

