/*
 * Decompiled with CFR 0.152.
 */
package cz.xtf.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WaitingUtils {
    private static final Logger log = LoggerFactory.getLogger(WaitingUtils.class);
    public static final long DEFAULT_MILLIS_TO_WAIT = 1000L;
    public static final String DEFAULT_REASON = "unspecified";

    private WaitingUtils() {
    }

    public static void waitSilently() {
        WaitingUtils.waitSilently(1000L, DEFAULT_REASON);
    }

    public static void waitSilently(long millis) {
        WaitingUtils.waitSilently(millis, DEFAULT_REASON);
    }

    public static void waitSilently(String reason) {
        WaitingUtils.waitSilently(1000L, reason);
    }

    public static void waitSilently(long millis, String reason) {
        try {
            log.info("action=wait status=START reason={} millis={}", (Object)reason, (Object)millis);
            Thread.sleep(millis);
            log.info("action=wait status=FINISH reason={} millis={}", (Object)reason, (Object)millis);
        }
        catch (InterruptedException ex) {
            log.warn("action=wait status=ERROR reason={} millis={}", new Object[]{reason, millis, ex});
        }
    }
}

